<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Users', function (Blueprint $table) {
            $table->bigIncrements('User_id'); // BIGINT(20) UNSIGNED AUTO_INCREMENT
            $table->string('Email', 255)->unique();
            $table->string('mobile_number', 15)->nullable()->unique();
            $table->string('Password_hash', 255);
            $table->enum('User_type', ['candidate', 'company', 'super_admin']);
            $table->enum('Status', ['active', 'inactive', 'banned'])->default('active');
            $table->timestamps();
            $table->index('Email');
            $table->index('mobile_number');
            $table->index('User_type');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Users');
    }
};
